/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.datapack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraftforge.forgespi.locating.IModFile;

public class DatapackHelper {
    public static final Gson GSON = (Gson)Util.m_137537_(() -> {
        GsonBuilder builder = new GsonBuilder();
        builder.disableHtmlEscaping();
        return builder.create();
    });

    public static Supplier<InputStream> generatePackMeta(IModFile file, String description) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bout, StandardCharsets.UTF_8);
            JsonObject packFile = new JsonObject();
            JsonObject packSection = new JsonObject();
            packSection.addProperty("description", description);
            packSection.addProperty("pack_format", (Number)DatapackHelper.getPackFormat(file));
            packFile.add("pack", (JsonElement)packSection);
            writer.write(GSON.toJson((JsonElement)packFile) + "\n");
            ((Writer)writer).close();
            bout.close();
            byte[] data = bout.toByteArray();
            return () -> new ByteArrayInputStream(data);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create dynamic pack.mcmeta", e);
        }
    }

    private static int getPackFormat(IModFile mod) {
        int n;
        block9: {
            Path path = mod.findResource(new String[]{"pack.mcmeta"});
            if (!Files.exists(path, new LinkOption[0])) {
                return 9;
            }
            BufferedReader in = Files.newBufferedReader(path);
            try {
                JsonObject packInfo = (JsonObject)GSON.fromJson((Reader)in, JsonObject.class);
                n = packInfo.get("pack").getAsJsonObject().get("pack_format").getAsInt();
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            ((Reader)in).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return 9;
                }
            }
            ((Reader)in).close();
        }
        return n;
    }
}

